clearvars
close all

iseed = 0;
repeats = 10;
csm = 1;
logt = 4;
lognc = [5,5,5,6,6,6,6,6];
sLL = 20;
dt = 10;
measvalues = {'CompPack','SysPack','LessComms'};
linename = {'1 cpm','Many cpm','Reduced Comms'};
markers = {'bx','kx','rx'};
L = 50;
formatSpec = '%f';

nN=8;

tave=zeros(3,nN);
nodes=linspace(1,nN,nN);

for k=1:size(measvalues,2)
for j=1:8 %Number of nodes
    meas = measvalues{k};
    FILENAME = sprintf('%d%s%d,%d,%d,%d,%d,%d,%d.txt',iseed,meas,csm,j*16,logt,L,lognc(j),sLL,dt);
    fileID = fopen(FILENAME,'r');

    A(:,:) = fscanf(fileID,formatSpec)';
    tave(k,j)=0;
    for i=1:repeats*2
        if mod(i,2)==0
            tave(k,j)=tave(k,j)+A(1,i)/repeats;
        end
    end    
end
hold on, plot(nodes,tave(k,:),markers{k},'MarkerSize',10,'LineWidth',2);
end

xlim([0,nN+1]);
ylim([0,610]);

set(gca, 'FontSize', 24);
xlabel('$n_N$','interpreter','latex');
ylabel('Run Time (s)','interpreter','latex');

for i=1:3
    hold on, plot(2.3,240-i*60,markers{i},'MarkerSize',12,'LineWidth',2);
    text(2.49,240-i*60,linename{i},'FontSize',22,'interpreter','latex');
end

text(0.4,560,'$10^5$ systems per node','FontSize',20,'interpreter','latex');
text(0.4,510,'16 ppn','FontSize',20,'interpreter','latex');

set(gca,'linewidth',2);

plotname = sprintf('WScaling%d.png',csm);
saveas(gcf,plotname);